% c = u_colorpal([N]) U-shaped colormap
%
% Gives a palette with N colors (where N must be odd, typically 2^n-1)
% with an U-shape, i.e. it starts with a bright blue, darkens in blue
% shades to black, brightens in red shades to bright red. It is useful
% to plot images with negative and positive pixels. Default: N=255.

% Copyright (c) 1997 by Miguel A. Carreira-Perpinan

function c = u_colorpal(N)

% Argument defaults
if nargin==0 N=255; end;

g = 0:2/(N-1):1; % Grey gradation from 0 to 1 with (N+1)/2 values
c = [zeros(1,(N-1)/2) g; zeros(1,N); g((N+1)/2:-1:1) zeros(1,(N-1)/2)]';

