% movie_epg(f,m[,num[,s[,tol]) Movie of EPG frames
%
% Shows num pictures of the vector m+k*f where k is a real number in
% a certain range. Pauses s seconds between plots or until a key
% is pressed if s<0. All components of f are assumed to be in [0,1]; no
% normalisation is employed, other than multiplying by 63 to obtain
% greyscales.
% The range for k is determined by movie_range(f,m,0,1,tol) where tol>=0
% is a tolerance parameter to increase the admissible frames (default 0).
%
% f: 62-vector, the basis vector to be "pictorically represented".
% m: 62-vector, the mean of the data set.
% num: number of pictures to play. Default 10.
% s: number of seconds to pause between pictures; if s=-1 then wait for
%    return key to be pressed. Default 0.
% tol >= 0: tolerance for frames not in [0,1]. Default 0.
%
% See also movie_range.

% Copyright (c) 1997 by Miguel A. Carreira-Perpinan

function h = movie_epg(f,m,num,s,tol)

% Argument defaults
if nargin==2 num=10; end;
if nargin<=3 s=0; end;
if nargin<=4 tol=0; end;

[start,end] = movie_range(f,m,0,1,tol);
step=(end-start)/(num-1);
inc_f=step*f;
f=start*f+m;
% Movie
for k=start:step:end
  colormap(gray(64));
% 8x8 matrix normalised to 0..63 greyscales -- frame is assumed to be in [0,1]
  h = image(63*[0 f(1:6)' 0; f(7:14)'; f(15:22)'; f(23:30)'; f(31:38)'; f(39:46)'; f(47:54)'; f(55:62)']);
  title(['k = ',num2str(k),'   min=',num2str(min(f)),'   max=',num2str(max(f))]);
  axis('image');
  axis('off');
  f=f+inc_f;
  if s<0
    pause;
  else
    pause(s);
  end
end

