% epglist2ps(l,file[,grid[,bkg,squared_comp,scope,norm]) EPG frames to B&W EPS files
%
% Transforms a list of epg vectors into a set of EPS files.
%
% l: matrix of r x 62, to be transformed to r black and white Encapsulated
%    PostScript Files (EPSF).
% file: prefix file name for the output EPS files: file01 to filer.
% grid: 0 (no grid, default), 1 (dotted, full grid), 2 (solid outline).
% bkg: real number in [0,1] indicating the background grey level, from
%    0=black to 1=white (default). bkg=0.8 prints nicely.
% squared_comp: 1 (squared electrodes, default); 0 (circular electrodes).
% scope: should be either 0 or 2; see lin_normalise (default 2, i.e.
%    normalisation local to each vector).
% norm: see lin_normalise (default 1).
%
% See also epg2ps, epglist2pscollage, epg2pnm, epglist2pnm, image_epg_frame,
% image_matrix, matrix2pnm, matrix2ps, lin_normalise, u_colormap.

% Copyright (c) 1998 by Miguel A. Carreira-Perpinan

function epglist2ps(l,file,grid,bkg,squared_comp,scope,norm)

% Argument defaults
if nargin==2 grid=0; end;
if nargin<=3 bkg=1; end;
if nargin<=4 squared_comp=1; end;
if nargin<=5 scope=2; end;
if nargin<=6 norm=1; end;

[r c]=size(l);
l = lin_normalise(l,norm,scope);	% Normalise here
for i=1:r
  if i<10
    name=[file,'.0',int2str(i)];
    else name=[file,'.',int2str(i)];
  end;
  epg2ps(l(i,1:62)',name,grid,bkg,squared_comp,0);	% Don't normalise again
end

