% epglist2pnm(l,file[,scope,cmap[,norm]) EPG frames to PNM bitmap files
%
% Transforms a list of epg vectors into a set of pgm (ppm) files.
%
% l: matrix of r x 62, to be transformed to r 8x16 pgm (ppm) ascii images.
% file: prefix file name for the output pgm (ppm) files: file01 to filer.
% scope, cmap, norm: see image_epg_frame. scope should be either 0 or 2
% (default 2, i.e. normalisation local to each vector).
%
% See also epg2pnm, epg2ps, epglist2ps, epglist2pscollage, image_epg_frame,
% image_matrix, matrix2pnm, matrix2ps, lin_normalise, u_colormap.

% Copyright (c) 1997 by Miguel A. Carreira-Perpinan

function epglist2pnm(l,file,scope,cmap,norm)

% Argument defaults
if nargin==2 scope=2; end;
if nargin<=3 cmap='u'; end;
if nargin<=4 if cmap=='u' norm=3; else norm=1; end; end;

[r c]=size(l);
l = lin_normalise(l,norm,scope);	% Normalise here
for i=1:r
  if i<10
    name=[file,'.0',int2str(i)];
    else name=[file,'.',int2str(i)];
  end;
  epg2pnm(l(i,1:62)',name,cmap,0);	% Don't normalise again
end

