% [lower,upper] = movie_range(f,m,l,u[,tol]) Range for an EPG movie
%
% Gives the interval [lower,upper] over which a real parameter k can
% vary so that all the components of the vector m + k*f stay in the
% interval [l-tol*(u-l),u+tol*(u-l)], where f and m are vectors of the
% same dimension and 0=<tol (default 0) is a percentage tolerance to
% overspill from [l,u].
% Preconditions: l <= m_i <= u for all components m_i of m.
%
% See also movie_epg.

% Copyright (c) 1997 by Miguel A. Carreira-Perpinan

function [lower,upper] = movie_range(f,m,l,u,tol)

% Argument defaults
if nargin==4 tol=0; end;

lower=max(min((l-tol*(u-l)-m)./f,(u+tol*(u-l)-m)./f));
upper=min(max((l-tol*(u-l)-m)./f,(u+tol*(u-l)-m)./f));

