
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/times.h>
#include <sys/time.h>
#include <limits.h>
#include <signal.h>

#define TIMER ITIMER_VIRTUAL

int TIMEOUT;        /* Global variable telling a running job that time is up */

void timeout()
{
  TIMEOUT++;     /* This will be detected by the main program at convenience */
  signal(SIGVTALRM, timeout);
}

void initTimer(struct itimerval *timer, int time)
{
  timer->it_interval.tv_sec = time/1000;
  timer->it_interval.tv_usec = 1000*(time-1000*(time/1000));
  timer->it_value.tv_sec = time/1000;
  timer->it_value.tv_usec = 1000*(time-1000*(time/1000));
  signal(SIGVTALRM, timeout);
  TIMEOUT = 0;
  setitimer(TIMER, timer, NULL);
}

long elapsedTime(struct itimerval *timer)
{
  long elapsed;

  getitimer(TIMER, timer);
  elapsed = 1000*(timer->it_interval.tv_sec-timer->it_value.tv_sec);
  elapsed += (timer->it_interval.tv_usec - timer->it_value.tv_usec)/1000;
  if (TIMEOUT) elapsed += TIMEOUT*(timer->it_interval.tv_sec*1000 +
                                   timer->it_interval.tv_usec/1000);
  return elapsed;
}
