/* gp-mc.c: Generic program for doing Monte Carlo with Gaussian Processes
 *
 * (c) Copyright 1996 by Carl Edward Rasmussen. */ 

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <sys/time.h>
#include "rand.h"
#include "util.h"

real *w,                                                  /* hyperparameters */
     *dw1,                                     /* hyperparameter derivatives */
     *z,                                                   /* momentum terms */
     *q,                                 /* help variable - used by fgeval() */
     **K, **K1, **K2;                                       /* main matrices */
int  nfgeval,  /* number of func/grad evals. so far; incremented by fgeval() */
     no_wts,                                    /* number of hyperparameters */
     no_inp,                                              /* input dimension */
     no_tar;                                            /* number of targets */
struct itimerval timer;
struct exampleset train;

extern void init();
extern void leapfrog(FILE *df, real RHO, real EPSILON,
                                                  int num, int mod, int start);

setTime(struct itimerval *timer, long current)
{
  timer->it_value.tv_sec -= current/1000;  
  setitimer(ITIMER_VIRTUAL, timer, timer);
}

main(int argc, char **argv)
{
  double r;
  char   trainfile[50], logfile[50];
  int    i, length, mod, current = 1;
  long   seed, tm = 0;
  FILE   *logf;

  time(&seed);           /* get a seed based on the time if none is provided */
  if (argc<4 || argc>5 || argc==5 && ((seed = atoi(argv[4])) <= 0)) {
    fprintf(stderr,
    "Usage: %s log-file instance-number [@]length[{%%|+}logInterval] [seed]\n",
          argv[0]); exit(-1); }
  rand_seed((int) seed);

  parse_length(argv[3], &length, &mod);
  if (length<0)
    initTimer(&timer, -length*1000);                /* limit by compute time */
  else
    initTimer(&timer, 604800000);              /* this is a week of cpu time */

  sprintf(logfile, "touch %s.%s", argv[1], argv[2]); system(logfile);
  sprintf(logfile, "%s.%s", argv[1], argv[2]);
  if ((logf = fopen(logfile, "r+")) == NULL) {
    fprintf(stderr, "Could not open log-file %s for writing ...bye!\n",
                     logfile); exit(-1); }

  sprintf(trainfile,"train.%s", argv[2]);
  train.num = -1; no_inp = -1;                   /* default for "don't know" */
  loadExamples(&train, &no_inp, (no_tar = 1, &no_tar), trainfile, NULL);

  init();

  K  = createMatrix(train.num, train.num);
  K1 = createMatrix(train.num, train.num);
  K2 = createMatrix(train.num, train.num);
  z = (real*) malloc((size_t) no_wts*sizeof(real));
  for (i=0; i<no_wts; i++) z[i] = 0.0;
  dw1 = (real*) malloc((size_t) no_wts*sizeof(real));
  q = (real*) malloc((size_t) train.num*sizeof(real));

  while (fscanf(logf, "%d %ld %lf %lf %lf", &current, &tm, &r, &r, &r) == 5) {
    for (i=0; i<no_wts; i++) { fscanf(logf, "%lf", &r); w[i] = r; }
    for (i=0; i<no_wts; i++) { fscanf(logf, "%lf", &r); z[i] = r; }
  }    
  fseek(logf, (long) 0, SEEK_END);            /* prepare logfile for writing */
  if (length>0) 
    leapfrog(logf, 0.95, 0.5, length, mod, current);
  else if (tm<-1000*length) {
    setTime(&timer, tm);
    leapfrog(logf, 0.95, 0.5, length, mod, current);
  }
}
