
#include <math.h>
#include <stdlib.h>
#include "util.h"


FILE *openPredFile(char *name, char *instance)
{
  char df[10];
  FILE *fp;
  
  sprintf(df, name, instance);
  if ((fp=fopen(df, "w")) == NULL) {
    fprintf(stderr, "Could not open file \"%s\" for writing... bye!\n", df);
    exit(-1);
  }
  return fp;
}

real **createMatrix(int rows, int cols)
{
  int  i;
  real **x;

  x = (real **) malloc((size_t) rows*sizeof(real *));
  x[0] = (real *) malloc((size_t) rows*cols*sizeof(real));
  for (i=1; i<rows; i++) x[i] = x[i-1]+cols;
  return x;
}

real sq(real x) { return x*x; } 

static real read_num(int *c, FILE *fp)  /* private function for loadExamples */
{
  int  neg = 0, i = 0;
  real x = 0.0;

  switch (*c) {  
  case '-':
    neg = 1;
  case '+':
    *c = getc(fp); 
  case '0': case '1': case '2': case '3': case '4':
  case '5': case '6': case '7': case '8': case '9':
    while (*c >= '0' && *c <= '9') { x = 10.0*x+(*c-'0'); *c = getc(fp); } 
  case '.':
    if (*c == '.') {
      *c = getc(fp);
      while (*c>='0' && *c<='9') { i++; x = 10.0*x+(*c-'0'); *c = getc(fp); } 
      x /= pow(10.0, (double) i);
    }
    if (neg) x = -x; neg = 0;
    if (*c == 'e' || *c == 'E') {
      *c = getc(fp); i = 0; 
      if (*c == '+' || *c == '-') { if (*c == '-') neg = 1; *c = getc(fp); }  
      while (*c >= '0' && *c <= '9') { i = 10*i+(*c-'0'); *c = getc(fp); }
      if (neg) i = -i; x *= pow(10, (double) i);
    }
    return x;
  case '\n':
    *c = getc(fp);
    break;
  default:                                    /* discard uninteresting stuff */
    while ((*c < '0' || *c > '9') && *c != '.' &&  *c != '-' && *c != '+' &&
            *c != '\n' && *c != EOF) *c = getc(fp);
  }
} 

void loadExamples(ex, numInp, numTar, df, df2)
  struct exampleset *ex;      /* examples will be returned in this structure */
  int  *numInp,                      /* specifies & returns number of inputs */
       *numTar;                     /* specifies & returns number of targets */
  char *df,                            /* name of file to read examples from */
       *df2;                 /* optional second file if targets are separate */

{
  FILE *fp, *fp2;
  char NUM[] = "+-0.123456789";
  int  i, j,                                       /* miscellaneous counters */
       m, m2, n,      /* counters for inputs, targets and number of examples */
       c;       /* holds characters from the input between calls to read_num */
  
  
  if ((fp=fopen(df, "r")) == NULL) {
    fprintf(stderr, "Could not open data file %s for reading... bye!\n", df);
    exit(-1);
  }
  if (df2 && ((fp2=fopen(df2, "r")) == NULL)) {
    fprintf(stderr, "Could not open data file %s for reading... bye!\n", df2);
    exit(-1);
  } 
  
  c = ' '; n = 0;                  /* check syntax of the first example file */
  while (c != EOF) {
    i = 0;
    read_num(&c, fp);
    while (c != EOF && c != '\n') {       /* "i" counts number of attributes */
      if (strchr(NUM, c)) i++;
      read_num(&c, fp);
    }
    if (n == 0) m = i;    /* if first line, then store number of attr in "m" */
    if (i == m)        /* check that line has the right number of attributes */
      n++;                                    /* if so, increment line count */
    else if (c != EOF || i != 0) { /* otherwise, print error message and die */
      fprintf(stderr,
             "Error while reading data file %s, line %d, token %d ...bye!\n",
              df, n+1, i);
      exit(-1);
    }
  }
  if (ex->num == -1)
    ex->num = n;
  else if (ex->num != n) {
    fprintf(stderr,
            "Error: read %d examples from file %s; %d were expected ...bye!\n",
             n, df, ex->num);
    exit(-1);
  }
  rewind(fp);       /* rewind the file, so we are ready to read the examples */
  
  
  if (df2) {                    /* if it exists, check syntax of target file */
    c = ' '; n = 0;
    while (c != EOF) {
      i = 0;
      read_num(&c, fp2);
      while (c != EOF && c != '\n') {       /* "i" counts the number of attr */
        if (strchr(NUM, c)) i++;
        read_num(&c, fp2);
      }
      if (n == 0) m2 = i;     /* if first line, store number of attr in "m2" */
      if (i == m2)     /* check that line has the right number of attributes */
        n++;                                  /* if so, increment line count */
      else if (c != EOF || i != 0) {       /* otherwise, print error and die */
        fprintf(stderr,
             "Error while reading data file %s, line %d, token %d ...bye!\n",
             df2, n+1, i);
        exit(-1);
      }
    }    
    if (n != ex->num) {
      fprintf(stderr,
            "Different number of examples in input and target file ...bye!\n");
      exit(-1);
    }
    if (*numTar == -1)
      *numTar = m2;
    else if (*numTar != m2) {
      fprintf(stderr,
         "Error: found %d target attributes in file %s; expected %d ...bye!\n",
         m2, df2, *numTar);
      exit(-1);
    }
    rewind(fp2);
  } 
  
  if (df2) {
    if (*numInp == -1)
      *numInp = m;
    else if (*numInp != m) {
      fprintf(stderr,
          "Error: expected %d input attributes in file %s; found %d ...bye!\n",
          *numInp, df, m);
      exit(-1);
    }
  }
  else {                           /* everything was read from a single file */
    if (*numInp == -1) {
      if (*numTar == -1) *numTar = 1;           /* assume 1 target attribute */
      *numInp = m-*numTar;
    }
    else {
      if (*numTar == -1) {
        if ((*numTar = m-*numInp) < 0) {
          fprintf(stderr, 
          "Error: found only %d input attr in file %s; expected >%d ...bye!\n",
            m, df, *numInp); 
          exit(-1); 
        }
      }
      else if (m != *numInp+*numTar) {
          fprintf(stderr,
               "Error: found %d attributes in file %s; expected %d ...bye!\n",
               m, df, *numInp+*numTar);
          exit(-1);
        }
    }
  } 
  
  ex->inp = createMatrix(ex->num, *numInp);
  if (numTar) ex->tar = createMatrix(ex->num, *numTar); 
  
  if (df2) {
    fprintf(stderr,
     "Reading %4d examples of %3d inputs from \"%s\"\n", ex->num, *numInp, df);
    fprintf(stderr,
    "                     and %3d target(s) from \"%s\"\n", *numTar, df2);
  }
  else {
    fp2 = fp;                    /* now both pointers point to the same file */
    fprintf(stderr,
        "Reading %4d examples of %3d inputs and %3d target(s) from \"%s\"\n",
         ex->num, *numInp, *numTar, df);
  }
  c = ' ';
  for (i=0; i<ex->num; i++) {               /* read the examples into arrays */
    for (j=0; j<*numInp; j++) {
      while (!strchr(NUM, c)) read_num(&c, fp);
      ex->inp[i][j] = read_num(&c, fp); 
    }
    for (j=0; j<*numTar; j++) {
      while (!strchr(NUM, c)) read_num(&c, fp2);
      ex->tar[i][j] = read_num(&c, fp2);
    } 
  } 
  fclose(fp); if (df2) fclose(fp2);  
}
