/* gp-ml.c: Generic program for doing maximum likelihood with Gaussian
 * Processes
 *
 * (c) Copyright 1996 by Carl Edward Rasmussen. */ 

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <sys/time.h>
#include "util.h"

real *w,                                                  /* hyperparameters */
     *q,                                 /* help variable - used by fgeval() */
     **K, **K1, **K2;                                       /* main matrices */
int  no_wts,                                    /* number of hyperparameters */
     no_inp,                                              /* input dimension */
     no_tar;                                            /* number of targets */
struct itimerval timer;
struct exampleset train;

extern real *dw1, *dw2, *s;                /* arrays for the conj() function */

extern void init();
extern int conj(int *iter, int *epoch, int *restart, real *costvalue);
extern void initTimer(struct itimerval *timer, int time);
extern long elapsedTime(struct itimerval *timer);

main(argc, argv)
  int  argc;
  char **argv;
{
  int  j, k, restart, succ, length, mod, iter;
  real costvalue;
  extern int TIMEOUT;
  long nexttime;
  char   trainfile[50], logfile[50];
  FILE   *logf;

  if (argc<3 || argc>4) {
    fprintf(stderr,
    "Usage: %s log-file instance-number [@]length[{%%|+}logInterval]\n",
          argv[0]); exit(-1); }

  parse_length(argv[3], &length, &mod);
  if (length<0)
    initTimer(&timer, -length*1000);                /* limit by compute time */
  else
    initTimer(&timer, 604800000);              /* this is a week of cpu time */

  sprintf(logfile, "touch %s.%s", argv[1], argv[2]); system(logfile);
  sprintf(logfile, "%s.%s", argv[1], argv[2]);
  if ((logf = fopen(logfile, "r+")) == NULL) {
    fprintf(stderr, "Could not open log-file %s for writing ...bye!\n",
                     logfile); exit(-1); }

  sprintf(trainfile, "train.%s", argv[2]);
  train.num = -1; no_inp = -1;                   /* default for "don't know" */
  loadExamples(&train, &no_inp, (no_tar = 1, &no_tar), trainfile, NULL);
  init();

  K  = createMatrix(train.num, train.num);
  K1 = createMatrix(train.num, train.num);
  K2 = createMatrix(train.num, train.num);
  dw1 = (real*) malloc((size_t) no_wts*sizeof(real));
  dw2 = (real*) malloc((size_t) no_wts*sizeof(real));
  s = (real*) malloc((size_t) no_wts*sizeof(real));
  q = (real*) malloc((size_t) train.num*sizeof(real));

  restart = 1; iter = 0; nexttime = elapsedTime(&timer);
  do {
    succ = conj((j=1, &j), (k=0, &k), &restart, &costvalue); iter++;
    if (((mod>0) && !(iter % mod)) ||
        ((mod<0) && (elapsedTime(&timer)>nexttime))) { 
      fprintf(logf, "%6d %8d %10.6f %10.6f %10.6f", iter, elapsedTime(&timer),
                                                         costvalue, 0.0, 0.0);
      for (j=0; j<no_wts; j++) fprintf(logf, " %10.6f", w[j]);
      for (j=0; j<no_wts; j++) fprintf(logf, " %10.6f", 0.0);
      fprintf(logf, "\n"); fflush(logf);
      nexttime -= 1000*abs(length)/mod;             /* set next time to save */
    }
  } while ((succ) && !(TIMEOUT) && (iter<length || length<0));
}











